#ifndef __CAnimation__
#define __CAnimation__

#include "CControl.hpp"
#include "../Graphics/CImageManager.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CControl;
using Exponent::GUI::Graphics::CImageManager;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CAnimation CAnimation.hpp
			 * @brief Displays an animation. You control the frame number with the controls float value
			 *
			 * @date 11/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CAnimation.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CAnimation : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 */
				CAnimation(IControlRoot *root, const long uniqueId, const CRect &area);

				/**
				 * Destruction
				 */
				virtual ~CAnimation();

//	===========================================================================

				/**
				 * Set the image
				 * @param theImage The image to display
				 * @param heightOfEachFrame The height of each frame of the animation strip
				 * @param numberOfFrames The total animtion length in frames
				 * @param invertAnimation If true a value of 1.0 indicates the beggining of the animation (rather than the normal 0.0 being te beggining).
				 */
				virtual void setAnimationImage(IImage *theImage, const long heightOfEachFrame, const long numberOfFrames, const bool invertAnimation = false);

				/**
				 * Set the animation image
				 * @param animationReference The animation image
				 * @param invertAnimation If true, expects animation to run bottom to top, else runs top to bottom
				 */
				virtual void setAnimationImage(CImageManager::CAnimationReference *animationReference, const bool invertAnimation = false);

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

			protected:

//	===========================================================================

				long m_frameHeight;					/**< Height of each frame */
				long m_numberOfFrames;				/**< Total number of frames in the animation */
				CRect m_offsetArea;					/**< Area we are offset by */
				bool m_invertAnimationStrip;		/**< Should the animation be played backwards? */
			};
		}
	}
}
#endif	// End of CAnimation.hpp